#define x64

#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.Core.Logging;

#if x64
	using WintabDN_x64;
#else 
	using WintabDN_x86;
#endif

#endregion usings



namespace VVVV.Nodes
{

    #region PluginInfo
    [PluginInfo(Name = "Tablet", Category = "Device Wintab1.4",Author = "kopffarben.de", Help = "For WinTab Tablets", Tags = "",AutoEvaluate = true)]
    #endregion PluginInfo


    public class TabletNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Enable", DefaultValue = 1.0, Order = 0)]
		public IDiffSpread<bool> FEnable;
		
		[Input("Queue", DefaultValue = 1.0, Order = 1)]
		public IDiffSpread<bool> FQueue;
		
		[Input("Map to Monitor", DefaultValue = 1.0, Order = 2)]
		public IDiffSpread<bool> FMap;
		
		[Input("Monitor Width", DefaultValue = 1600, Order = 3)]
		public IDiffSpread<int> FInResolutionX;
		
		[Input("Monitor Height", DefaultValue = 1200, Order = 4)]
		public IDiffSpread<int> FInResolutionY;
		
		[Input("Hide MouseCursor", DefaultValue = 1, Order = 5)]
		public IDiffSpread<bool> FInHideCursor;

		
		[Input("Exclusive", DefaultValue = 1, Order = 6)]
		public IDiffSpread<bool> FInExclusive;

		
		[Output("Proximity" , Order = 0)]
		public ISpread<bool> FProximityOutput;
		
		[Output("X" , Order = 1)]
		public ISpread<double> FXOutput;
		
		[Output("Y", Order = 2)]
		public ISpread<double> FYOutput;
		
		[Output("Z", Order = 3)]
		public ISpread<double> FZOutput;
		
		[Output("Pressure", Order = 4)]
		public ISpread<double> FPOutput;
		
		[Output("TangentPressure", Order = 5)]
		public ISpread<double> FTPOutput;
		
		[Output("Azimuth", Order = 6)]
		public ISpread<double> FAziOutput;
		
		[Output("Altitude", Order = 7)]
		public ISpread<double> FAltOutput;
		
		[Output("Twist", Order = 8)]
		public ISpread<double> FTwistOutput;

		[Output("Buttons", Order = 9)]
		public ISpread<bool> FButtonOutput;	
		
		/*
		[Output("Left Express Keys", Order = 10)]
		public ISpread<bool> FLExKeyOutput;	
		
		[Output("Right Express Keys", Order = 11)]
		public ISpread<bool> FRExKeyOutput;	
		
		[Output("Left TouchStrip", Order = 12)]
		public ISpread<double> FLTStripOutput;	
		
		[Output("Right TouchStrip", Order = 13)]
		public ISpread<double> FRTStripOutput;	
		
		[Output("Left TouchRing", Order = 14)]
		public ISpread<double> FLTRingOutput;	
		
		[Output("Right TouchRing", Order = 15)]
		public ISpread<double> FRTRingOutput;	
		*/
		
		[Import()]
		public ILogger FLogger;
		
		private int InMapCorrectX = 1;
		private int InMapCorrectY = 1;
		private int InExtX;
		private int InExtY;

		
		private CWintabContext m_logContext = null; 
		private CWintabData m_wtData = null;
		CWintabContext logContext = null;
		
		List<double> tabletX;
		List<double> tabletY;
		List<double> tabletZ;
		List<double> tabletP;
		List<double> tabletTP;
		List<double> tabletAzi;
		List<double> tabletAlt;
		List<double> tabletTwist;
		
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (FEnable[0])
			{
				if (FEnable.IsChanged || FInHideCursor.IsChanged)
				{
					try
					{
						FButtonOutput.SliceCount = 3;
						FProximityOutput.SliceCount = 1;
						tabletX = new List<double>();
						tabletY = new List<double>();
						tabletZ = new List<double>();
						tabletP = new List<double>();
						tabletTP = new List<double>();
						tabletAzi = new List<double>();
						tabletAlt = new List<double>();
						tabletTwist = new List<double>();
		
						// Open a Wintab context that does not send Wintab data events.
						m_logContext = OpenQueryDigitizerContext();
						
						// Create a data object.
						m_wtData = new CWintabData(m_logContext);
						
						m_wtData.SetWTPacketEventHandler(MyWTPacketEventHandler);
					}
					catch (Exception ex)
					{
						FLogger.Log(LogType.Debug, ex.ToString());
					}
				} else {
					
					if (FInExclusive[0])
	            	{
	            		logContext.SetOverlapOrder(true);
	            	}
					
					if (tabletX.Count > 0)
					{
						FProximityOutput[0] = true;
						
						if (FQueue[0])
						{
							
							FXOutput.SliceCount = tabletX.Count;
							FYOutput.SliceCount = tabletX.Count;
							FZOutput.SliceCount = tabletX.Count;
							FPOutput.SliceCount = tabletX.Count;
							FTPOutput.SliceCount = tabletX.Count;
		            		FAziOutput.SliceCount = tabletX.Count;
							FAltOutput.SliceCount = tabletX.Count;
							FTwistOutput.SliceCount = tabletX.Count;
							
							for (int idx = 0; idx < tabletX.Count; idx++)
					        {
					        	if (FMap[0])
					        	{
					        		FXOutput[idx] = tabletX[idx]/(double)InMapCorrectX;
					        		FYOutput[idx] = tabletY[idx]/(double)InMapCorrectY;
					        	} else {
					        		FXOutput[idx] = tabletX[idx]/(double)InExtX;
					        		FYOutput[idx] = tabletY[idx]/(double)InExtY;
					        	}
					        	FZOutput[idx] = tabletZ[idx]/1023;
								FPOutput[idx] = tabletP[idx]/1023;
					        	FTPOutput[idx] = tabletTP[idx]/1023;
								FAziOutput[idx] = tabletAzi[idx]/360;
								FAltOutput[idx] = tabletAlt[idx]/90;
								FTwistOutput[idx] = tabletTwist[idx]/360;
					        	
					        }
						} else {
							FXOutput.SliceCount = 1;
							FYOutput.SliceCount = 1;
							FZOutput.SliceCount = 1;
							FPOutput.SliceCount = 1;
							FTPOutput.SliceCount = 1;
							FAziOutput.SliceCount = 1;
							FAltOutput.SliceCount = 1;
							FTwistOutput.SliceCount = 1;
							
							if (FMap[0])
				        	{
				        		FXOutput[0] = tabletX[tabletX.Count-1]/(double)InMapCorrectX;
				        		FYOutput[0] = tabletY[tabletX.Count-1]/(double)InMapCorrectY;
				        	} else {
				        		FXOutput[0] = tabletX[tabletX.Count-1]/(double)InExtX;
				        		FYOutput[0] = tabletY[tabletX.Count-1]/(double)InExtY;
				        	}
				        	FZOutput[0] = tabletZ[tabletX.Count-1]/1023;
							FPOutput[0] = tabletP[tabletX.Count-1]/1023;
				        	FTPOutput[0] = tabletTP[tabletX.Count-1]/1023;
							FAziOutput[0] = tabletAzi[tabletX.Count-1]/360;
							FAltOutput[0] = tabletAlt[tabletX.Count-1]/90;
							FTwistOutput[0] = tabletTwist[tabletX.Count-1]/360;
							
						}
						
						tabletX.Clear();
						tabletY.Clear();
						tabletZ.Clear();
						tabletP.Clear();
						tabletTP.Clear();
						tabletAzi.Clear();
						tabletAlt.Clear();
						tabletTwist.Clear();
					} else {
						FProximityOutput[0] = false;
						FXOutput[0] = FXOutput[FXOutput.SliceCount-1];
						FYOutput[0] = FYOutput[FYOutput.SliceCount-1];
						FZOutput[0] = FZOutput[FZOutput.SliceCount-1];
						FPOutput[0] = FPOutput[FPOutput.SliceCount-1];
						FTPOutput[0] = FTPOutput[FTPOutput.SliceCount-1];
						FAziOutput[0] = FAziOutput[FAziOutput.SliceCount-1];
						FAltOutput[0] = FAltOutput[FAltOutput.SliceCount-1];
						FTwistOutput[0] = FTwistOutput[FTwistOutput.SliceCount-1];
						FXOutput.SliceCount = 1;
						FYOutput.SliceCount = 1;
						FZOutput.SliceCount = 1;
						FPOutput.SliceCount = 1;
						FTPOutput.SliceCount = 1;
						FAziOutput.SliceCount = 1;
						FAltOutput.SliceCount = 1;
						FTwistOutput.SliceCount = 1;
					}
					
				}
			} else if (FEnable.IsChanged) {
				bool status = false;
				if (m_logContext != null)
                {
                    status = m_logContext.Close();
                    m_logContext = null;
                    m_wtData = null;
                }
				FLogger.Log(LogType.Debug, "Context Close: " + status + "\n");
			}
			
		}
		
		private CWintabContext OpenQueryDigitizerContext()
        {
            bool status = false;
            try
            {
                // Get the default digitizing context.  Turn off events.  Control system cursor.
                logContext = CWintabInfo.GetDefaultDigitizingContext(ECTXOptionValues.CXO_SYSTEM);

                logContext.Options |= (uint)ECTXOptionValues.CXO_MESSAGES;
            	
            	if (FInHideCursor[0])
            	{
            		logContext.Options &= ~(uint)ECTXOptionValues.CXO_SYSTEM;
            	}
                

                if (logContext == null)
                {
                    FLogger.Log(LogType.Debug, "OpenQueryDigitizerContext: FAILED to get default digitizing context.\n");
                    return null;
                }

                // Modify the digitizing region.
                logContext.Name = "WintabDN Query Data Context";
            	InExtX			= logContext.InExtX;
            	InExtY			= logContext.InExtY;
            	InMapCorrectX	= (logContext.InExtX / logContext.SysExtX *FInResolutionX[0])+133;
				InMapCorrectY	= (logContext.InExtY / logContext.SysExtY *FInResolutionY[0])+399;
            	
				FLogger.Log(LogType.Debug, "InMapCorrectX: " + InMapCorrectX + "  InMapCorrectY: " + InMapCorrectY + "\n");
            	
                // Open the context, which will also tell Wintab to send data packets.
                status = logContext.Open();

                FLogger.Log(LogType.Debug, "Context Open: " + (status ? "PASSED [ctx=" + logContext.HCtx + "]" : "FAILED") + "\n");
            }
            catch (Exception ex)
            {
                FLogger.Log(LogType.Debug, "OpenQueryDigitizerContext: ERROR : " + ex.ToString());
            }

            return logContext;
        }
		
		private void MyWTPacketEventHandler(Object sender_I, MessageReceivedEventArgs eventArgs_I)
        {
            //System.Diagnostics.Debug.WriteLine("Received WT_PACKET event");
            if (m_wtData == null)
            {
                return;
            }

            try
            {
                
				uint pktID = (uint)eventArgs_I.Message.WParam;
				WintabPacket pkt = m_wtData.GetDataPacket((uint)eventArgs_I.Message.LParam, pktID);
            	
				if (pkt.pkContext != 0)
				{
					if ((UInt32)pkt.pkChanged > 20)
					{
						tabletX.Add((double)pkt.pkX);
						tabletY.Add((double)pkt.pkY);
						tabletZ.Add((double)pkt.pkZ);
						tabletP.Add(pkt.pkNormalPressure);
						tabletTP.Add(pkt.pkTangentPressure);
						tabletAzi.Add(pkt.pkOrientation.orAzimuth/10);
						tabletAlt.Add(pkt.pkOrientation.orAltitude/10);
						tabletTwist.Add(pkt.pkOrientation.orTwist/10);
						switch ((UInt32)pkt.pkButtons)
						{
						    case 131072:
						        FButtonOutput[0] = true;
						        break;
						    case 65536:
						        FButtonOutput[0] = false;
						        break;
							case 131073:
						        FButtonOutput[1] = true;
						        break;
						    case 65537:
						        FButtonOutput[1] = false;
						        break; 
							case 131074:
						        FButtonOutput[2] = true;
						        break;
						    case 65538:
						        FButtonOutput[2] = false;
						        break; 
						}
						//FLogger.Log(LogType.Debug, "SCREEN: pkX: " + pkt.pkX + ", pkY:" + pkt.pkY + ", pressure: " + pkt.pkNormalPressure + " Count:" + tabletX.Count + " pkButtons:" + (UInt32)pkt.pkButtons);
					}
				}
            }
            catch (Exception ex)
            {
                throw new Exception("FAILED to get packet data: " + ex.ToString());
            }
        }
	}
}
